<?php

namespace App\Models;

use App\Trait\Imageable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Blog extends Model
{
    /** @use HasFactory<\Database\Factories\BlogFactory> */
    use HasFactory, Imageable;

    protected $fillable = [
        'title',
        'slug',
        'content',
        'status',
        'category_id',
        'user_id',
        'destination_id',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class)->getType('blog');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function destination(): BelongsTo
    {
        return $this->belongsTo(Destination::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    public function scopePopular($query)
    {
        return $query->withCount('comments')
            ->orderByDesc('comments_count')
            ->limit(5);
    }
}
